/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj;

import java.io.Serializable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class Periodo
implements Serializable {
    private static final long serialVersionUID = -1951452232367866106L;
    private int anio;
    private int mes;
    private final LocalDate fechaDeclarada;
    private LocalDate diciembre2012 = new LocalDate(2012, 12, 31);
    private LocalDate marzo2015 = new LocalDate(2015, 3, 1);
    private LocalDate agosto2015 = new LocalDate(2015, 8, 1);
    private LocalDate junio2015 = new LocalDate(2015, 6, 1);
    private LocalDate enero2016 = new LocalDate(2016, 1, 1);
    private LocalDate mayo2016 = new LocalDate(2016, 5, 1);
    private LocalDate junio2016 = new LocalDate(2016, 6, 1);
    private LocalDate septiembre2016 = new LocalDate(2016, 9, 1);
    private LocalDate enero2018 = new LocalDate(2018, 1, 1);
    private LocalDate enero2020 = new LocalDate(2020, 1, 1);
    public LocalDate junio2025 = new LocalDate(2025, 6, 1);
    public LocalDate agosto2025 = new LocalDate(2025, 8, 1);

    public Periodo(int anio, int mes) {
        this.anio = anio;
        this.mes = mes;
        this.fechaDeclarada = new LocalDate(anio, mes, 1);
    }

    public Periodo() {
        this.fechaDeclarada = new LocalDate();
    }

    public boolean isAnexoEnPeriodoDesdeJunio2016() {
        return this.fechaDeclarada.isEqual((ReadablePartial)this.junio2016) || this.fechaDeclarada.isAfter((ReadablePartial)this.junio2016);
    }

    public boolean isAnexoEnPeriodoDesdeMayo2016() {
        return this.fechaDeclarada.isEqual((ReadablePartial)this.mayo2016) || this.fechaDeclarada.isAfter((ReadablePartial)this.mayo2016);
    }

    public boolean isAnexoEnPeriodoHastaAbril2016() {
        return this.fechaDeclarada.isBefore((ReadablePartial)this.mayo2016);
    }

    public boolean isAnexoEnPeriodoHasta(LocalDate periodoPermitido) {
        return this.fechaDeclarada.isBefore((ReadablePartial)periodoPermitido);
    }

    public boolean isAnexoEnPeriodoDesdeEnero2016() {
        return this.fechaDeclarada.isEqual((ReadablePartial)this.enero2016) || this.fechaDeclarada.isAfter((ReadablePartial)this.enero2016);
    }

    public boolean isPeriodoDeAnexoDesdeMarzo2015() {
        return this.fechaDeclarada.isAfter((ReadablePartial)this.marzo2015) || this.fechaDeclarada.isEqual((ReadablePartial)this.marzo2015);
    }

    public boolean isAnexoEnPeriodoDesdeMarzo2015HastaAbril2016() {
        return this.isPeriodoDeAnexoDesdeMarzo2015() && this.isAnexoEnPeriodoHastaAbril2016();
    }

    public boolean isPeriodoDeAnexoDesdeJunio2015() {
        return this.fechaDeclarada.isEqual((ReadablePartial)this.junio2015) || this.fechaDeclarada.isAfter((ReadablePartial)this.junio2015);
    }

    public boolean isPeriodoDesdeEnero2013() {
        return this.anio >= 2013;
    }

    public boolean isPeriodoAnteriorA2013() {
        return this.anio < 2013;
    }

    public boolean isPeridoDeAnexoDesdeEnero2013aFebrero2015() {
        return this.fechaDeclarada.isAfter((ReadablePartial)this.diciembre2012) && this.fechaDeclarada.isBefore((ReadablePartial)this.marzo2015);
    }

    public boolean isPeriodoDesdeMarzo2015AJulio2015() {
        return (this.fechaDeclarada.isAfter((ReadablePartial)this.marzo2015) || this.fechaDeclarada.isEqual((ReadablePartial)this.marzo2015)) && this.fechaDeclarada.isBefore((ReadablePartial)this.agosto2015);
    }

    public boolean isPeriodoDesdeAgosto2015() {
        return this.fechaDeclarada.isEqual((ReadablePartial)this.agosto2015) || this.fechaDeclarada.isAfter((ReadablePartial)this.agosto2015);
    }

    public boolean isPeriodoHastaDiciembre2019() {
        return this.fechaDeclarada.isBefore((ReadablePartial)this.enero2020);
    }

    public int getAnio() {
        return this.anio;
    }

    public int getMes() {
        return this.mes;
    }

    public LocalDate getFechaDeclarada() {
        return this.fechaDeclarada;
    }

    public boolean isAnexoEnPeriodoHastaMayo2016() {
        return this.fechaDeclarada.isBefore((ReadablePartial)this.mayo2016) || this.fechaDeclarada.isEqual((ReadablePartial)this.mayo2016);
    }

    public boolean isAnexoEnPeriodoHastaJunio2016() {
        return this.fechaDeclarada.isBefore((ReadablePartial)this.junio2016) || this.fechaDeclarada.isEqual((ReadablePartial)this.junio2016);
    }

    public boolean isAnexoEnPeriodoHastaSeptiembre2016() {
        return this.fechaDeclarada.isBefore((ReadablePartial)this.septiembre2016) || this.fechaDeclarada.isEqual((ReadablePartial)this.septiembre2016);
    }

    public boolean isPeriodoDesdeEnero2018() {
        return this.fechaDeclarada.isEqual((ReadablePartial)this.enero2018) || this.fechaDeclarada.isAfter((ReadablePartial)this.enero2018);
    }
}

